<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TicketPriority extends Model 
{

    protected $table = 'ticket_priorities';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'color');
    protected $visible = array('name', 'description', 'color');

    public function tickets()
    {
        return $this->hasMany('Ticket');
    }

}